﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Threading;
using System.Drawing;
using FDK;

namespace StrokeStyleT
{
	class CStage演奏 : CActivity
	{
		// プロパティ

		public int n描画開始チップ番号
		{
			get;
			set;
		}
		public Dictionary<E判定, int> dicヒットした回数
		{
			get;
			protected set;
		}
		public bool b演奏終了済み
		{
			get { return ( this.n描画開始チップ番号 < 0 ); }
		}
		public Dictionary<E演奏レーン, List<Eチップ>> dic演奏レーンtoチップ
		{
			get;
			protected set;
		}
		public long n曲固有遅延差分の演奏中の変動量ms = 0;
		public long n曲固有遅延差分の演奏前の値ms = 0;

		// メソッド

		public CStage演奏()
		{
			this.list子Activities.Add( this.Actフリップボード = new CMActフリップボード( D3DFormat.A8R8G8B8 ) );
			this.list子Activities.Add( this.Act英数字描画 = new CAct英数字描画() );
			this.list子Activities.Add( this.Act演奏チップ = new CAct演奏チップ() );
			this.n描画開始チップ番号 = -1;
		}

		public void t演奏位置指定( int n演奏開始小節番号 )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない ||
				Global.Song.r現在演奏中の曲のスコア == null ||
				Global.Song.r現在演奏中の曲のスコア.listチップ == null )
				return;

			if( n演奏開始小節番号 < 0 )
				throw new ArgumentOutOfRangeException( "演奏開始小節番号に負数が指定されました。" );
			//-----------------
			#endregion

			// すべてのチップを演奏前の状態に戻す。

			foreach( var chip in Global.Song.r現在演奏中の曲のスコア.listチップ )
			{
				chip.b未ヒット = true;
				chip.b可視 = true;
			}


			// 描画開始チップを検索し、演奏位置を移動する。

			this.n描画開始チップ番号 = -1;
			long n背景動画チップの発声時刻ms = 0;

			for( int i = 0; i < Global.Song.r現在演奏中の曲のスコア.listチップ.Count; i++ )
			{
				var chip = Global.Song.r現在演奏中の曲のスコア.listチップ[ i ];

				if( chip.n小節番号 >= n演奏開始小節番号 )	// 描画開始チップを発見。
				{
					#region [ chip の発声時刻よりちょっと前に時刻に変更し、this.n描画開始チップ番号 を決定する。]
					//-----------------

					// 描画開始チップを変更する。（仮決め）

					this.n描画開始チップ番号 = i;


					// 演奏タイマを描画開始チップの発声時刻（よりちょっと早め）に変更する。

					const double db早める時間ms = 500.0;

					this.nプレイヤーモード時の演奏開始時刻ms = (long) ( chip.n発声時刻ms - db早める時間ms );	// 初めての進行のときに演奏タイマの初期値として設定される。
					if( this.nプレイヤーモード時の演奏開始時刻ms < 0 )
						this.nプレイヤーモード時の演奏開始時刻ms = 0;


					// 時刻を早めたので、this.n描画開始チップ番号 も変更するならする。

					for( int j = this.n描画開始チップ番号 - 1; j >= 0; j-- )	// 現在の描画開始チップから前に戻っていく。
					{
						var chip2 = Global.Song.r現在演奏中の曲のスコア.listチップ[ j ];
						if( chip2.n発声時刻ms >= (double) this.nプレイヤーモード時の演奏開始時刻ms )
						{
							this.n描画開始チップ番号 = j;


							// ヒット処理を元に戻す。

							chip2.b未ヒット = true;
							chip2.b可視 = true;

							if( chip2.eチップ == Eチップ.背景動画 )
							{
								n背景動画チップの発声時刻ms = 0;
								this.b最初の進行で背景動画の再生を開始する = false;
							}
						}
						else
							break;
					}
					//-----------------
					#endregion

					// 描画開始チップが見つかったので、On進行() も初めからやり直す。
					this.b初めての進行 = true;

					break;
				}
				else
				{
					#region [ 開始位置より過去のチップはヒット処理する。]
					//-----------------
					chip.bヒット済 = true;
					chip.b可視 = false;

					if( chip.eチップ == Eチップ.背景動画 )
					{
						n背景動画チップの発声時刻ms = chip.n発声時刻ms;
						this.b最初の進行で背景動画の再生を開始する = true;
					}
					//-----------------
					#endregion
				}
			}

			#region [ 描画開始チップが見つからなかった場合はここまで。何もしない。]
			//-----------------
			if( this.n描画開始チップ番号 < 0 )
			{
				this.b最初の進行で背景動画の再生を開始する = false;	// 背景動画も再生しない。
				return;
			}
			//-----------------
			#endregion

			#region [ 背景動画の再生を開始する。]
			//-----------------
			if( this.b最初の進行で背景動画の再生を開始する )
			{
				long n再生位置ms = this.nプレイヤーモード時の演奏開始時刻ms - n背景動画チップの発声時刻ms;
				Global.Song.r現在演奏中のスコアの背景動画.t再生する((ulong) (n再生位置ms * 10) );
				Global.Song.r現在演奏中のスコアのBGM.t再生位置を変更する( n再生位置ms );
			}
			//-----------------
			#endregion
		}
		public void t演奏レーンチップ対応表をConfigに合わせて再構築する()
		{
			this.dic演奏レーンtoチップ = new Dictionary<E演奏レーン, List<Eチップ>>() {
				{ E演奏レーン.LeftCymbal, new List<Eチップ>() { Eチップ.LeftCrash } },
				{ E演奏レーン.FootPedal, new List<Eチップ>() { Eチップ.HiHat_Foot } },
				{ E演奏レーン.HiHat, new List<Eチップ>() { Eチップ.HiHat_Close, Eチップ.HiHat_HalfOpen, Eチップ.HiHat_Open } },
				{ E演奏レーン.Snare, new List<Eチップ>() { Eチップ.Snare, Eチップ.Snare_ClosedRim, Eチップ.Snare_Ghost, Eチップ.Snare_OpenRim } },
				{ E演奏レーン.Tom1, new List<Eチップ>() { Eチップ.Tom1, Eチップ.Tom1_Rim } },
				{ E演奏レーン.Bass, new List<Eチップ>() { Eチップ.Bass } },
				{ E演奏レーン.Tom2, new List<Eチップ>() { Eチップ.Tom2, Eチップ.Tom2_Rim } },
				{ E演奏レーン.Tom3, new List<Eチップ>() { Eチップ.Tom3, Eチップ.Tom3_Rim } },
				{ E演奏レーン.RightCymbal, new List<Eチップ>() { Eチップ.RightCrash } },
				{ E演奏レーン.Unknown, new List<Eチップ>() },
			};

			// 以下は Users.Config の値によって変化する。

			this.dic演奏レーンtoチップ[ ( Global.User.Config.ChinaLeft ) ? E演奏レーン.LeftCymbal : E演奏レーン.RightCymbal ].Add( Eチップ.China );
			this.dic演奏レーンtoチップ[ ( Global.User.Config.RideLeft ) ? E演奏レーン.LeftCymbal : E演奏レーン.RightCymbal ].Add( Eチップ.Ride );
			this.dic演奏レーンtoチップ[ ( Global.User.Config.RideLeft ) ? E演奏レーン.LeftCymbal : E演奏レーン.RightCymbal ].Add( Eチップ.Ride_Cup );
			this.dic演奏レーンtoチップ[ ( Global.User.Config.SplashLeft ) ? E演奏レーン.LeftCymbal : E演奏レーン.RightCymbal ].Add( Eチップ.Splash );
		}
		public E演奏レーン tチップが属する演奏レーンを返す( Eチップ eチップ )
		{
			foreach( var obj in Enum.GetValues( typeof( E演奏レーン ) ) )
			{
				var e演奏レーン = (E演奏レーン) obj;
				if( this.dic演奏レーンtoチップ[ e演奏レーン ].Contains( eチップ ) )
					return e演奏レーン;
			}
			return E演奏レーン.Unknown;
		}
		public E演奏レーン tチップが属する演奏レーンを返す( Cチップ cc )
		{
			return this.tチップが属する演奏レーンを返す( cc.eチップ );
		}

		public override void On活性化()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してる )
				return;
			//-----------------
			#endregion

			this.n描画開始チップ番号 = 0;
			this.b最初の進行で背景動画の再生を開始する = false;
			this.nプレイヤーモード時の演奏開始時刻ms = 0;
			this.n曲固有遅延差分の演奏中の変動量ms = 0;		// ⊿(2)
			this.n曲固有遅延差分の演奏前の値ms = 0;			// (2)

			#region [ this.dicヒットした回数 のクリア。 ]
			//-----------------
			this.dicヒットした回数 = new Dictionary<E判定, int>();
			foreach( var obj in Enum.GetValues( typeof( E判定 ) ) )
				this.dicヒットした回数[ (E判定) obj ] = 0;
			//-----------------
			#endregion


			// スコアがある場合はその背景動画を生成する（読み込みはGUIスレッドだが DirectShow は描画スレッドで作成する。）

			#region [ 背景動画を生成する。]
			//-----------------
			try
			{
				if( Global.Song.r現在演奏中の曲のスコア != null )
					Global.Song.r現在演奏中のスコアの背景動画 = new CMediaSession( Global.App.hWindow, Global.Song.str背景動画ファイルパス, false, false );	// オーディオレンダラなし、ループなし
			}
			catch( Exception e )
			{
				Utils.t例外の詳細をログに出力する( e );
				Global.Song.r現在演奏中のスコアの背景動画 = null;
				throw;	// そのまま下の失敗例外へ。
			}
			//-----------------
			#endregion


			// 再生遅延対策。

			#region [ 曲固有の遅延差分があるなら取得する。]
			//-----------------
			if( Global.Song.r現在演奏中の曲 != null )
			{
				if( Global.SystemConfig.SongProperties.ContainsKey( Global.Song.r現在演奏中の曲.ScoreFile ) )
					this.n曲固有遅延差分の演奏前の値ms = Global.SystemConfig.SongProperties[ Global.Song.r現在演奏中の曲.ScoreFile ].n遅延差分ms;	// (2)
			}
			//-----------------
			#endregion
			#region [ 背景動画チップの発声時刻を修正する。]
			//-----------------
			if( Global.Song.r現在演奏中のスコアのBGM != null )
			{
				if( this.b最初の進行で背景動画の再生を開始する )
				{
					#region [ (A) 既に背景動画チップがヒット処理されている場合 → 再生開始位置をずらす ]
					//-----------------
					long n新しい再生開始位置ms =
						Global.Song.r現在演奏中のスコアの背景動画.n現在のグラフの再生位置ms
						- this.n曲固有遅延差分の演奏前の値ms				// (2)
						- Global.SoundDevice.n実出力遅延ms;					// (3)

					n新しい再生開始位置ms = Math.Max( n新しい再生開始位置ms, 0 );		// 再生位置が負数になった場合は 0 とする。

					Global.Song.r現在演奏中のスコアの背景動画.t再生する( (ulong) ( n新しい再生開始位置ms * 1000 * 10 ) );	// 100ns 単位で指定。
					Global.Song.r現在演奏中のスコアのBGM.t再生位置を変更する( n新しい再生開始位置ms );
					//-----------------
					#endregion
				}
				else
				{
					#region [ (B) まだ背景動画チップがヒット処理されていない場合 → 背景動画チップの発声時刻をずらす ]
					//-----------------
					foreach( var chip in Global.Song.r現在演奏中の曲のスコア.listチップ )
					{
						if( chip.eチップ != Eチップ.背景動画 )
							continue;


						// 発声時刻をずらす。

						chip.n発声時刻ms =
							chip.n発声時刻ms
							- Global.SoundDevice.n実出力遅延ms				// (3)
							- this.n曲固有遅延差分の演奏前の値ms;			// (2)


						// 発声時刻が負数になった場合は、プレイヤーモードと同じ方法で、いきなり途中から再生を開始する準備をする。

						if( chip.n発声時刻ms < 0 )
						{
							long n超過分ms = -chip.n発声時刻ms;

							Global.Song.r現在演奏中のスコアの背景動画.t再生する( (ulong) ( n超過分ms * 1000 * 10 ) );
							Global.Song.r現在演奏中のスコアのBGM.t再生位置を変更する( n超過分ms );

							this.b最初の進行で背景動画の再生を開始する = true;

							chip.bヒット済 = true;	// 既にヒットしたことになる。
							chip.b可視 = false;
						}

						break;
					}
					//-----------------
					#endregion
				}
			}
			//-----------------
			#endregion
			#region [ 自動演奏 ON のドラムチップの発声時刻を修正する。]
			//-----------------
			if( Global.Song.r現在演奏中の曲のスコア != null )
			{
				foreach( var chip in Global.Song.r現在演奏中の曲のスコア.listチップ )
				{
					#region [ ドラムチップ以外はスキップ。]
					//-----------------
					if( chip.eチップ == Eチップ.BPM ||
						chip.eチップ == Eチップ.Unknown ||
						chip.eチップ == Eチップ.小節メモ ||
						chip.eチップ == Eチップ.小節線 ||
						chip.eチップ == Eチップ.拍線 ||
						chip.eチップ == Eチップ.背景動画 )
						continue;
					//-----------------
					#endregion

					if( Global.User.Config.dicAutoPlay[ Global.Stage.演奏.tチップが属する演奏レーンを返す( chip ) ] )	// 自動演奏 ON である
					{
						chip.n発声時刻ms =
							chip.n発声時刻ms
							- Global.SoundDevice.n実出力遅延ms;	// (3)
					}
				}
			}
			//-----------------
			#endregion

			base.On活性化();
		}
		public override void On非活性化()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			Global.tDisposeする( this.FPS ); this.FPS = null;
			Global.tDisposeする( this.VPS ); this.VPS = null;


			// Global.EnvirionmentProperties を更新する。

			if( Global.PlayerMode.bプレイヤーモードではない )	// プレイヤーモードの場合は⊿(1),⊿(2) はどこにも反映されない。
			{
				// (2) = (2) + ⊿(2) に更新。

				if( Global.SystemConfig.SongProperties.ContainsKey( Global.Song.r現在演奏中の曲.ScoreFile ) )
				{
					Global.SystemConfig.SongProperties[ Global.Song.r現在演奏中の曲.ScoreFile ].n遅延差分ms += this.n曲固有遅延差分の演奏中の変動量ms;
				}
				else if( this.n曲固有遅延差分の演奏中の変動量ms != 0 )		// ⊿(2)≠0 かつ EnvironmentProperties.dic曲固有属性[] に曲を登録されていないなら新規登録する。
				{
					Global.SystemConfig.SongProperties.Add(
						Global.Song.r現在演奏中の曲.ScoreFile,
						new SystemConfig.CSongProperties() { n遅延差分ms = this.n曲固有遅延差分の演奏中の変動量ms } );
				}

				// ⊿(2)≠0 のときは EnvironmentProperties.xml を保存する。

				if( this.n曲固有遅延差分の演奏中の変動量ms != 0 )	// ⊿(2)
				{
					string path = System.IO.Path.Combine( Folder.stgユーザ共通フォルダ, Properties.Resources.XMLNAME_SYSTEM_CONFIG );
					CXMLFile<SystemConfig>.t保存する( Global.SystemConfig, path );
					Trace.TraceInformation( Folder.tファイルパスをマクロ付きパスに変換する( path ) + " を保存しました。" );
				}
			}

			base.On非活性化();
		}
		public override void Onリソースの作成( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			this.txHitBar = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenPlay hitbar.png" ) );
			this.txFrame = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenPlay frame.png" ) );
			this.txFrameBack = new CTexture( hDevice, Folder.stgテーマファイル( @"ScreenPlay frame back.png" ) );
			if( this.txFrameBack != null )
				this.txFrameBack.n透明度 = (int) ( 255 * Global.User.Config.PlayFrameOpacity / 100.0 );
			this.txWhite = new CTexture( hDevice, Folder.stgテーマファイル( @"White 64x64.png" ) );

			base.Onリソースの作成( hDevice );
		}
		public override void Onリソースの解放()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			Global.tDisposeする( ref this.txFrame );
			Global.tDisposeする( ref this.txFrameBack );
			Global.tDisposeする( ref this.txHitBar );
			Global.tDisposeする( ref this.txWhite );

			base.Onリソースの解放();
		}
		public override int On進行()
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない ||
				Global.SoundTimer == null )
			//  Global.Song.r現在演奏中のスコアの背景動画		のチェックは行わない。（異常系のため）
			//  Global.Song.r現在演奏中のスコアのBGM			のチェックは行わない。（異常系のため）
			{
				return (int) E進行結果.継続;
			}
			//-----------------
			#endregion

			#region [ プレイヤーモードかつ待機中（指定された曲がない）場合はここで帰還。]
			//-----------------
			if( Global.PlayerMode.bプレイヤーモードである && Global.Song.r現在演奏中の曲のスコア == null )	// 待機中
				return (int) E進行結果.継続;
			//-----------------
			#endregion


			// 進行。

			#region [ 初めての進行処理。演奏タイマ開始。]
			//-----------------
			if( this.b初めての進行 )
			{
				// 必要なら背景動画を再生開始する（プレイヤーモードのときなど）。

				if( this.b最初の進行で背景動画の再生を開始する )
				{
					// 演奏タイマのリセットは再生開始直後に行う。
					Global.Song.r現在演奏中のスコアの背景動画.t再生する( 0, Global.Song.r現在演奏中のスコアのBGM );	// 動画と音声を同期して再生する。
				}


				// タイマリセット前に蓄積されているバッファ入力をすべてポーリング（＝クリア）する。

				Global.Input.tポーリング();


				// FPS/VPS 測定開始。

				this.FPS = new CFPS();
				this.VPS = new CFPS();


				// 演奏タイマをリセットする。
				// ・プレイヤーモード時は途中から開始されることが多いので、this.nプレイヤーモード時の演奏開始時刻ms を加算する。（通常演奏では 0）。
				// ・また、チップ発声時刻シフト値（Global.Global.Song.r現在演奏中の曲のスコア.r環境依存プロパティ.nチップ発声時刻シフト値ms）を加算する必要は無い。
				//　（加算は Act演奏チップ にて行われるため。）

				Global.SoundTimer.tリセット();
				Global.SoundTimer.n現在時刻ms = this.nプレイヤーモード時の演奏開始時刻ms;

				this.b初めての進行 = false;
			}
			//-----------------
			#endregion

			#region [ タイマ更新。]
			//-----------------
			Global.SoundTimer.t更新();
			//-----------------
			#endregion
			#region [ 描画開始チップの入れ替え。]
			//-----------------
			if( Global.Song.r現在演奏中の曲のスコア.listチップ != null &&
				Global.Song.r現在演奏中の曲のスコア.listチップ.Count > 0 )
			{
				var score = Global.Song.r現在演奏中の曲のスコア;

				if( Global.Stage.演奏.n描画開始チップ番号 >= 0 )
				{
					// ヒットバーとチップの距離[pixel;符号付き]を算出する。

					int n距離px = score.n指定された時間msに対応する符号付きピクセル数を返す(
						Global.SoundTimer.n現在時刻ms
						- ( score.listチップ[ Global.Stage.演奏.n描画開始チップ番号 ].n描画時刻ms + this.n曲固有遅延差分の演奏中の変動量ms )
						);


					// チップのY座標を算出する。

					int y = Theme.szウィンドウ.Height - Theme.演奏.n画面下端からヒットバー中央までの距離px + n距離px;


					// 画面下外に出ていれば描画開始チップ番号を更新する。

					if( y > Theme.szウィンドウ.Height + 20 )	// +20 は適当なマージン
					{
						Global.Stage.演奏.n描画開始チップ番号++;

						if( Global.Stage.演奏.n描画開始チップ番号 >= score.listチップ.Count )
							Global.Stage.演奏.n描画開始チップ番号 = -1;		// 演奏終了。
					}
				}
			}
			//-----------------
			#endregion

			#region [ 譜面が終了した → ステージ終了 ]
			//-----------------
			if( Global.Stage.演奏.n描画開始チップ番号 < 0 )
				return (int) E進行結果.クリア;
			//-----------------
			#endregion

			this.Act演奏チップ.On進行・背景動画();				// チップ(1) 背景動画
			this.Act演奏チップ.Act演奏パッド.On進行();			// パッドライン
			this.Act演奏チップ.On進行・コンボ();				// COMBO
			this.Act演奏チップ.On進行・小節線拍線();			// チップ(2) 小節線・拍線
			this.Act演奏チップ.Act演奏パッド.On進行();			// パッド
			this.Act演奏チップ.Act演奏判定文字列.On進行();		// 判定文字列
			this.Act演奏チップ.On進行・ドラムチップ();			// チップ(3) その他
			this.Act演奏チップ.Act演奏チップファイア.On進行();	// チップファイア
			this.Act演奏チップ.Act演奏ビッグファイア.On進行();	// ビッグファイア
			if( this.FPS != null ) this.FPS.tカウンタ更新();	// FPS


			// 入力。

			#region [ ESC → プレイヤーモードじゃなければ終了、プレイヤーモードなら無視。]
			//-----------------
			if( Global.Input.Input管理.Keyboard.bキーが押された( Key.Escape ) )
			{
				if( Global.PlayerMode.bプレイヤーモードではない )
					return (int) E進行結果.キャンセル;
			}
			//-----------------
			#endregion

			if( Global.PlayerMode.bプレイヤーモードではない )
			{
				#region [ パッド入力 → チップヒット判定、ヒット処理 ]
				//-----------------

				// すべての入力イベントについて……
				foreach( var ie in Global.Input.listMIDI入力イベント )
				{
					E演奏レーン eレーン;
					Eチップ eチップ;

					#region [ キー入力 ie が、押されていないものだったり、KeyAssign に登録されていないキーだったら無視。]
					//-----------------
					if( ie.b離された )
						continue;	// 押されてないものは無視。

					Global.Input.t入力イベントに対応する演奏レーンとチップを取得する( ie, out eレーン, out eチップ );

					if( eチップ == Eチップ.Unknown || eレーン == E演奏レーン.Unknown )
						continue;	// 登録されていないものは無視。
					//-----------------
					#endregion

					#region [ パッドアニメ開始。]
					//-----------------
					this.Act演奏チップ.Act演奏パッド.tヒット( eレーン );
					//-----------------
					#endregion
					#region [ 仮想ドラムサウンド再生開始。]
					//-----------------
					if( Global.User.Config.HitSound )
					{
						int n音量 = (int) ( ( ie.nVelocity / 127.0 ) * ( Cチップ.n最大音量 - Cチップ.n最小音量 + 1 ) + Cチップ.n最小音量 );
						Global.VirtualDrums.tドラムサウンドを再生する( eチップ, n音量 );	// サウンド再生開始
					}
					//-----------------
					#endregion

					bool bヒットしている = false;
					var eヒット判定 = E判定.MISS;
					int nヒットしたチップのY座標 = 0;
					Cチップ rヒットしたチップ = null;

					#region [ 譜面上のチップと ie とのヒット判定を行う。]
					//-----------------
					long n入力時刻ms = ie.nTimeStamp;	// DirectShow側タイマの「現在時刻」と同軸に修正済み → Global.Inpur.t入力イベントリストを構築する() を参照

					rヒットしたチップ = this.Act演奏チップ.t指定されたパッドラインと時刻でヒットしたチップを返す(
						Global.Song.r現在演奏中の曲のスコア,
						eレーン,
						n入力時刻ms,
						out eヒット判定,
						out nヒットしたチップのY座標 );

					#region [ LeftCymbal, RightCymbal, HiHat については相互に互換性がある（シンバルフリー）。]
					//-----------------
					if( rヒットしたチップ == null )
					{
						switch( eレーン )
						{
							case E演奏レーン.LeftCymbal:

								// RightCymbal
								rヒットしたチップ = this.Act演奏チップ.t指定されたパッドラインと時刻でヒットしたチップを返す(
									Global.Song.r現在演奏中の曲のスコア, E演奏レーン.RightCymbal, n入力時刻ms, out eヒット判定, out nヒットしたチップのY座標 );

								if( rヒットしたチップ == null )
								{
									// HiHat
									rヒットしたチップ = this.Act演奏チップ.t指定されたパッドラインと時刻でヒットしたチップを返す(
										Global.Song.r現在演奏中の曲のスコア, E演奏レーン.HiHat, n入力時刻ms, out eヒット判定, out nヒットしたチップのY座標 );
								}
								break;

							case E演奏レーン.RightCymbal:

								if( ( eチップ != Eチップ.Ride ) && ( eチップ != Eチップ.Ride_Cup ) )	// Ride はシンバルフリーに含めない。
								{
									// LeftCymbal
									rヒットしたチップ = this.Act演奏チップ.t指定されたパッドラインと時刻でヒットしたチップを返す(
										Global.Song.r現在演奏中の曲のスコア, E演奏レーン.LeftCymbal, n入力時刻ms, out eヒット判定, out nヒットしたチップのY座標 );

									if( rヒットしたチップ == null )
									{
										// HiHat
										rヒットしたチップ = this.Act演奏チップ.t指定されたパッドラインと時刻でヒットしたチップを返す(
											Global.Song.r現在演奏中の曲のスコア, E演奏レーン.HiHat, n入力時刻ms, out eヒット判定, out nヒットしたチップのY座標 );
									}
								}
								break;

							case E演奏レーン.HiHat:

								// LeftCymbal
								rヒットしたチップ = this.Act演奏チップ.t指定されたパッドラインと時刻でヒットしたチップを返す(
									Global.Song.r現在演奏中の曲のスコア, E演奏レーン.LeftCymbal, n入力時刻ms, out eヒット判定, out nヒットしたチップのY座標 );

								if( rヒットしたチップ == null )
								{
									// RightCymbal
									rヒットしたチップ = this.Act演奏チップ.t指定されたパッドラインと時刻でヒットしたチップを返す(
										Global.Song.r現在演奏中の曲のスコア, E演奏レーン.RightCymbal, n入力時刻ms, out eヒット判定, out nヒットしたチップのY座標 );

									if( rヒットしたチップ != null && ( rヒットしたチップ.eチップ == Eチップ.Ride || rヒットしたチップ.eチップ == Eチップ.Ride_Cup ) )
										rヒットしたチップ = null;		// Ride はシンバルフリーに含めない。
								}
								break;
						}
					}
					//-----------------
					#endregion

					bヒットしている = ( rヒットしたチップ != null );
					//-----------------
					#endregion

					if( bヒットしている )
					{
						#region [ チップファイア発火。]
						//-----------------
						this.Act演奏チップ.Act演奏チップファイア.t発火(
							eレーン,
							nヒットしたチップのY座標 - ( Theme.szウィンドウ.Height - Theme.演奏.n画面下端からヒットバー中央までの距離px ) ); // ファイアのY座標はヒット時のチップの位置とする。
						//-----------------
						#endregion
						#region [ ビッグファイア発火。]
						//-----------------
						if( this.Act演奏チップ.Act演奏ビッグファイア.b発火する( rヒットしたチップ ) )
							this.Act演奏チップ.Act演奏ビッグファイア.t発火();
						//-----------------
						#endregion
						#region [ 判定文字列表示。]
						//-----------------
						this.Act演奏チップ.Act演奏判定文字列.t表示( eレーン, eヒット判定 );
						//-----------------
						#endregion
						#region [ 判定のヒット回数の増加。]
						//-----------------
						Global.Stage.演奏.dicヒットした回数[ eヒット判定 ]++;
						//-----------------
						#endregion
						#region [ COMBO増加。]
						//-----------------
						if( eヒット判定 == E判定.PERFECT || eヒット判定 == E判定.GREAT || eヒット判定 == E判定.GOOD )
							this.Act演奏チップ.Act演奏コンボ.nCOMBO値++;
						else
							this.Act演奏チップ.Act演奏コンボ.nCOMBO値 = 0;	// Poor はコンボ切れ
						//-----------------
						#endregion

						rヒットしたチップ.bヒット済 = true;
						rヒットしたチップ.b可視 = false;
					}
				}
				//-----------------
				#endregion
			}

			#region [ Shift + カーソル上 → 曲固有遅延差分・増加 ]
			//-----------------
			if( this.bSHIFTキーが押されている &&
				Global.Input.Input管理.Keyboard.bキーが押された( Key.UpArrow ) )
			{
				this.t曲固有遅延差分の増減( +10 );
			}
			//-----------------
			#endregion
			#region [ Shift + カーソル下 → 曲固有遅延差分・減少 ]
			//-----------------
			else if( this.bSHIFTキーが押されている &&
				Global.Input.Input管理.Keyboard.bキーが押された( Key.DownArrow ) )
			{
				this.t曲固有遅延差分の増減( -10 );
			}
			//-----------------
			#endregion

			return (int) E進行結果.継続;
		}
		public override void On描画( IntPtr hDevice )
		{
			#region [ 実行条件チェック ]
			//-----------------
			if( this.b活性化してない )
				return;
			//-----------------
			#endregion

			#region [ 背景動画 ]
			//-----------------
			this.Act演奏チップ.On描画・背景動画( hDevice, CAct演奏背景動画.E種別.背景 );
			//-----------------
			#endregion
			#region [ フレーム ]
			//-----------------
			if( this.txFrame != null &&
				this.txFrameBack != null )
			{
				int n論理画面の高さpx = Theme.szウィンドウ.Height;
				int nフレーム画像の幅px = this.txFrame.sz画像サイズ.Width;
				int nフレーム画像の高さpx = this.txFrame.sz画像サイズ.Height;
				int nフレーム画像の縦方向描画個数 = n論理画面の高さpx / nフレーム画像の高さpx;

				// 胴体を縦につなげていく。

				for( int i = 0; i < nフレーム画像の縦方向描画個数; i++ )
				{
					int x = Theme.演奏.n画面左端からフレーム左までの距離px;
					int y = i * nフレーム画像の高さpx;

					this.txFrameBack.t2D描画( hDevice, x, y );
					this.txFrame.t2D描画( hDevice, x, y );
				}

				// 余り。

				int n余りpx = n論理画面の高さpx % nフレーム画像の高さpx;
				if( n余りpx != 0 )
				{
					int x = Theme.演奏.n画面左端からフレーム左までの距離px;
					int y = nフレーム画像の縦方向描画個数 * nフレーム画像の高さpx;
					var rc = new Rectangle( 0, 0, nフレーム画像の幅px, n余りpx );

					this.txFrameBack.t2D描画( hDevice, x, y, rc );
					this.txFrame.t2D描画( hDevice, x, y, rc );
				}
			}
			//-----------------
			#endregion
			#region [ パッドライン ]
			//-----------------
			this.Act演奏チップ.Act演奏パッド.On描画( hDevice, CAct演奏パッド.E描画対象.パッドライン );
			//-----------------
			#endregion
			#region [ COMBO ]
			//-----------------
			this.Act演奏チップ.On描画・コンボ( hDevice );
			//-----------------
			#endregion
			#region [ ビッグファイア ]
			//-----------------
			this.Act演奏チップ.Act演奏ビッグファイア.On描画( hDevice );
			//-----------------
			#endregion
			#region [ 小節線・拍線 ]
			//-----------------
			this.Act演奏チップ.On描画・小節線拍線( hDevice );
			//-----------------
			#endregion
			#region [ 背景動画のサムネイル ]
			//-----------------
			this.Act演奏チップ.On描画・背景動画( hDevice, CAct演奏背景動画.E種別.サムネイル );
			//-----------------
			#endregion
			#region [ ヒットバー ]
			//-----------------
			if( this.txHitBar != null )
			{
				this.txHitBar.t2D描画(
					hDevice,
					Theme.演奏.n画面左端からフレーム左までの距離px - 8,
					Theme.szウィンドウ.Height - Theme.演奏.n画面下端からヒットバー中央までの距離px - 22 );
			}
			//-----------------
			#endregion
			#region [ パッド ]
			//-----------------
			this.Act演奏チップ.Act演奏パッド.On描画( hDevice, CAct演奏パッド.E描画対象.パッド );
			//-----------------
			#endregion
			#region [ 判定文字列 ]
			//-----------------
			if( Global.PlayerMode.bプレイヤーモードではない )
				this.Act演奏チップ.Act演奏判定文字列.On描画( hDevice );	// プレイヤーモード時は非表示
			//-----------------
			#endregion
			#region [ チップ ]
			//-----------------
			this.Act演奏チップ.On描画・ドラムチップ( hDevice );
			//-----------------
			#endregion
			#region [ チップファイア ]
			//-----------------
			this.Act演奏チップ.Act演奏チップファイア.On描画( hDevice );
			//-----------------
			#endregion
			#region [ FPS(VPS) ]
			//-----------------
			if( this.VPS != null )	// 曲が再生されるまでは、この描画メソッドは呼ばれるが VPS は生成されていない。
				this.VPS.tカウンタ更新();

			if( this.FPS != null && this.VPS != null )
			{
				string msg = string.Format( "FPS(VPS): {0}({1})", this.FPS.n現在のFPS, this.VPS.n現在のFPS );
				int n幅 = msg.Length * 8;
				this.Act英数字描画.t表示( hDevice, Theme.szウィンドウ.Width - n幅, Theme.szウィンドウ.Height - 16, CAct英数字描画.E種別.白太, msg );
			}
			//-----------------
			#endregion
		}

		volatile CAct演奏チップ Act演奏チップ;
		CAct英数字描画 Act英数字描画;
		CMActフリップボード Actフリップボード;
		CTexture txFrame;
		CTexture txFrameBack;
		CTexture txHitBar;
		volatile CFPS FPS;
		volatile CFPS VPS;
		CTexture txWhite;

		bool bSHIFTキーが押されている
		{
			get
			{
				return ( Global.Input.Input管理.Keyboard.bキーが押されている( Key.RightShift ) ||
						 Global.Input.Input管理.Keyboard.bキーが押されている( Key.LeftShift ) );
			}
		}
		/// <summary>
		/// <para>演奏用タイマの開始時刻。On進行()の「初めての進行」のときに演奏タイマの初期値として設定される。</para>
		/// <para>通常は 0（曲頭）だが、プレイヤーモード時では途中から始める（＞0）場合が多い。</para>
		/// </summary>
		long nプレイヤーモード時の演奏開始時刻ms = 0;
		
		bool b最初の進行で背景動画の再生を開始する = false;

		void t曲固有遅延差分の増減( int n増減量ms )
		{
			this.n曲固有遅延差分の演奏中の変動量ms += n増減量ms;
			this.Actフリップボード.t表示( string.Format( "曲固有遅延差分: {0}ms", this.n曲固有遅延差分の演奏前の値ms + this.n曲固有遅延差分の演奏中の変動量ms ) );
		}
		void tフレーム背景の不透明度の増減( int n増減量 )
		{
			Global.User.Config.PlayFrameOpacity = Math.Max( Math.Min( Global.User.Config.PlayFrameOpacity + n増減量, 100 ), 0 );	// 0～100
			this.txFrameBack.n透明度 = (int) ( 255 * Global.User.Config.PlayFrameOpacity / 100.0 );

			this.Actフリップボード.t表示( string.Format( "フレーム背景の不透明度 = {0}％", Global.User.Config.PlayFrameOpacity ) );
		}
	}
}
